import { Value } from '../../../messages/Value';
import { IRpcError } from './RpcErrorType';
export declare enum RpcErrorCodes {
    INTERNAL_ERROR = 0,
    BAD_REQUEST = 1,
    TIMEOUT = 2,
    NOT_FOUND = 3,
    CONFLICT = 4,
    ID_TAKEN = 5,
    INVALID_METHOD = 6,
    INVALID_METHOD_NAME = 7,
    NO_METHOD_SPECIFIED = 8,
    METHOD_NOT_FOUND = 9,
    STOP = 10,
    DISCONNECT = 11,
    BUFFER_OVERFLOW = 12
}
export type RpcErrorValue = Value<RpcError>;
export declare class RpcError extends Error implements IRpcError {
    readonly message: string;
    readonly code: string | undefined;
    readonly errno: number;
    readonly errorId: string | undefined;
    readonly meta: unknown | undefined;
    static from(error: unknown): RpcError;
    static fromCode(errno: RpcErrorCodes, message?: string, meta?: unknown): RpcError;
    static internal(message?: string): RpcError;
    static invalidRequest(): RpcError;
    static validation(message: string, meta?: unknown): RpcError;
    static value(error: RpcError): RpcErrorValue;
    static valueFrom(error: unknown, def?: RpcErrorValue): RpcErrorValue;
    static valueFromCode(errno: RpcErrorCodes, message?: string): RpcErrorValue;
    static internalErrorValue(): RpcErrorValue;
    static isRpcError(error: unknown): error is RpcError;
    constructor(message: string, code: string | undefined, errno: number, errorId: string | undefined, meta: unknown | undefined);
    toJson(): IRpcError;
}
