"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiRpcCaller = void 0;
const tslib_1 = require("tslib");
const StaticRpcMethod_1 = require("../methods/StaticRpcMethod");
const StreamingRpcMethod_1 = require("../methods/StreamingRpcMethod");
const RpcCaller_1 = require("./RpcCaller");
class ApiRpcCaller extends RpcCaller_1.RpcCaller {
    constructor(_a) {
        var { api } = _a, rest = tslib_1.__rest(_a, ["api"]);
        super(Object.assign(Object.assign({}, rest), { getMethod: (name) => this.get(name) }));
        this.methods = new Map();
        for (const key in api) {
            const method = api[key];
            this.methods.set(key, (method.isStreaming ? new StreamingRpcMethod_1.StreamingRpcMethod(method) : new StaticRpcMethod_1.StaticRpcMethod(method)));
        }
    }
    get(name) {
        return this.methods.get(name);
    }
}
exports.ApiRpcCaller = ApiRpcCaller;
