"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createCaller = exports.sampleApi = void 0;
const tslib_1 = require("tslib");
const rxjs_1 = require("rxjs");
const operators_1 = require("rxjs/operators");
const json_type_1 = require("../../../../json-type");
const caller_1 = require("../caller");
const ApiRpcCaller_1 = require("../caller/ApiRpcCaller");
const ping = {
    isStreaming: false,
    call: () => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        return 'pong';
    }),
    res: json_type_1.t.Const('pong'),
};
const delay = {
    isStreaming: false,
    call: ({ timeout = 10 } = {}) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        yield new Promise((r) => setTimeout(r, timeout));
        return {
            done: true,
            timeout,
        };
    }),
};
let value = 0;
const notificationSetValue = {
    isStreaming: false,
    call: (params) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        value = params.value;
    }),
    res: json_type_1.t.Const(undefined),
};
const getValue = {
    isStreaming: false,
    call: () => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        return { value };
    }),
};
const delayStreaming = {
    isStreaming: true,
    call$: (req$) => {
        return req$.pipe((0, operators_1.take)(1), (0, operators_1.switchMap)(({ timeout = 10 } = {}) => {
            return (0, rxjs_1.from)(new Promise((r) => {
                setTimeout(() => {
                    r(timeout);
                }, timeout);
            }));
        }), (0, operators_1.map)((timeout) => ({
            done: true,
            timeout,
        })));
    },
};
const double = {
    isStreaming: false,
    validate: (data) => {
        if (typeof data !== 'object')
            throw caller_1.RpcError.validation('Payload must be object.');
        if (data === null)
            throw caller_1.RpcError.validation('Payload cannot be null.');
        if (typeof data.num !== 'number')
            throw caller_1.RpcError.validation('Payload .num field missing.');
    },
    call: ({ num }) => tslib_1.__awaiter(void 0, void 0, void 0, function* () { return ({ num: num * 2 }); }),
};
const error = {
    isStreaming: false,
    call: () => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        throw new caller_1.RpcError('this promise can throw', '', 0, '', undefined);
    }),
};
const getUser = {
    isStreaming: false,
    call: (request) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        return {
            id: request.id,
            name: 'Mario Dragi',
            tags: ['news', 'cola', 'bcaa'],
        };
    }),
};
const streamError = {
    isStreaming: true,
    call$: () => (0, rxjs_1.from)((() => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        throw caller_1.RpcError.internal('Stream always errors');
    }))()),
};
const utilTimer = {
    isStreaming: true,
    call$: () => (0, rxjs_1.timer)(10, 10),
};
const buildinfo = {
    isStreaming: true,
    call$: () => (0, rxjs_1.from)([
        {
            commit: 'AAAAAAAAAAAAAAAAAAA',
            sha1: 'BBBBBBBBBBBBBBBBBBB',
        },
    ]),
};
const count = {
    isStreaming: true,
    call$: (request$) => {
        return request$.pipe((0, operators_1.switchMap)(({ count }) => new rxjs_1.Observable((observer) => {
            let cnt = 0;
            const timer = setInterval(() => {
                observer.next(cnt++);
                if (cnt >= count) {
                    observer.complete();
                    clearInterval(timer);
                }
            }, 10);
            return () => {
                clearInterval(timer);
            };
        })));
    },
};
const doubleStringWithValidation = {
    isStreaming: false,
    validate: (request) => {
        if (!request || typeof request !== 'object')
            throw caller_1.RpcError.validation('Request must be object.');
        if (typeof request.foo !== 'string')
            throw caller_1.RpcError.validation('"foo" property missing.');
    },
    call: ({ foo }) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        return { bar: foo + foo };
    }),
};
const doubleStringWithValidation2 = {
    isStreaming: true,
    validate: (request) => {
        if (!request || typeof request !== 'object')
            throw caller_1.RpcError.validation('Request must be object.');
        if (typeof request.foo !== 'string')
            throw caller_1.RpcError.validation('"foo" property missing.');
    },
    call$: (req$) => {
        return req$.pipe((0, operators_1.map)(({ foo }) => ({ bar: foo + foo })));
    },
};
const passthroughStream = {
    isStreaming: true,
    call$: (req$) => req$,
};
exports.sampleApi = {
    ping,
    delay,
    notificationSetValue,
    getValue,
    delayStreaming,
    double,
    count,
    error,
    streamError,
    'auth.users.get': getUser,
    'util.info': buildinfo,
    'util.timer': utilTimer,
    doubleStringWithValidation,
    doubleStringWithValidation2,
    passthroughStream,
};
const createCaller = () => new ApiRpcCaller_1.ApiRpcCaller({ api: exports.sampleApi });
exports.createCaller = createCaller;
