"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RpcMessageStreamProcessorLocalClient = void 0;
const StreamingRpcClient_1 = require("./client/StreamingRpcClient");
class RpcMessageStreamProcessorLocalClient extends StreamingRpcClient_1.StreamingRpcClient {
    constructor(params) {
        super({
            send: (messages) => {
                Promise.resolve().then(() => {
                    this.params.server.onMessages(messages, this.params.ctx);
                });
            },
            bufferSize: 1,
            bufferTime: 0,
        });
        this.params = params;
        this.params.server.onSend = (messages) => {
            Promise.resolve().then(() => {
                this.onMessages(messages);
            });
        };
    }
}
exports.RpcMessageStreamProcessorLocalClient = RpcMessageStreamProcessorLocalClient;
