"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RpcDuplex = void 0;
const tslib_1 = require("tslib");
const msg = tslib_1.__importStar(require("../messages"));
class RpcDuplex {
    constructor(params) {
        this.client = params.client;
        this.server = params.server;
    }
    onMessages(messages, ctx) {
        const length = messages.length;
        for (let i = 0; i < length; i++)
            this.onMessage(messages[i], ctx);
    }
    onMessage(message, ctx) {
        if (message instanceof msg.RequestDataMessage)
            this.server.onRequestDataMessage(message, ctx);
        else if (message instanceof msg.RequestCompleteMessage)
            this.server.onRequestCompleteMessage(message, ctx);
        else if (message instanceof msg.RequestErrorMessage)
            this.server.onRequestErrorMessage(message, ctx);
        else if (message instanceof msg.ResponseUnsubscribeMessage)
            this.server.onUnsubscribeMessage(message);
        else if (message instanceof msg.NotificationMessage)
            this.server.onNotificationMessage(message, ctx);
        else if (message instanceof msg.ResponseCompleteMessage)
            return this.client.onResponseComplete(message);
        else if (message instanceof msg.ResponseDataMessage)
            return this.client.onResponseData(message);
        else if (message instanceof msg.ResponseErrorMessage)
            return this.client.onResponseError(message);
        else if (message instanceof msg.RequestUnsubscribeMessage)
            return this.client.onRequestUnsubscribe(message);
    }
    call$(method, data) {
        return this.client.call$(method, data);
    }
    call(method, data) {
        return this.client.call(method, data);
    }
    notify(method, data) {
        this.client.notify(method, data);
    }
    stop() {
        this.client.stop();
        this.server.stop();
    }
    disconnect() {
        this.client.disconnect();
        this.server.disconnect();
    }
}
exports.RpcDuplex = RpcDuplex;
