import type { JsonValueCodec } from '../../../json-pack/codecs/types';
import type * as msg from './messages';
export type ReactiveRpcClientMessage = msg.NotificationMessage | msg.RequestDataMessage | msg.RequestCompleteMessage | msg.RequestErrorMessage | msg.ResponseUnsubscribeMessage;
export type ReactiveRpcServerMessage = msg.ResponseDataMessage | msg.ResponseCompleteMessage | msg.ResponseErrorMessage | msg.RequestUnsubscribeMessage;
export type ReactiveRpcMessage = ReactiveRpcClientMessage | ReactiveRpcServerMessage;
export interface Message<P = unknown> {
    value?: undefined | unknown;
    validate(): void;
    toCompact(): P;
    encodeCompact(codec: JsonValueCodec): void;
    encodeBinary(codec: JsonValueCodec): void;
}
