"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonRpc2Error = exports.JsonRpc2Response = exports.JsonRpc2Request = exports.JsonRpc2Notification = exports.JsonRpc2Id = exports.system = void 0;
const json_type_1 = require("../../../../json-type");
exports.system = new json_type_1.TypeSystem();
const t = exports.system.t;
exports.JsonRpc2Id = t.num.options({ format: 'i32' });
exports.system.alias('JsonRpc2Id', exports.JsonRpc2Id);
exports.JsonRpc2Notification = t.Object(t.prop('jsonrpc', t.Const('2.0')), t.prop('method', t.str), t.propOpt('params', t.any));
exports.system.alias('JsonRpc2Notification', exports.JsonRpc2Notification);
exports.JsonRpc2Request = t.Object(t.prop('jsonrpc', t.Const('2.0')), t.prop('id', t.Ref('JsonRpc2Id')), t.prop('method', t.str.options({
    title: 'RPC method name',
    description: 'JSON RPC 2.0 method name.',
})), t.propOpt('params', t.any));
exports.system.alias('JsonRpc2Request', exports.JsonRpc2Request);
exports.JsonRpc2Response = t.Object(t.prop('jsonrpc', t.Const('2.0')), t.prop('id', t.Ref('JsonRpc2Id')), t.prop('result', t.any));
exports.system.alias('JsonRpc2Response', exports.JsonRpc2Response);
exports.JsonRpc2Error = t.Object(t.prop('jsonrpc', t.Const('2.0')), t.prop('id', t.Ref('JsonRpc2Id')), t.prop('error', t.Object(t.prop('message', t.str.options({
    title: 'Error message',
    description: 'A string providing a short description of the error.',
})), t.prop('code', t.num.options({
    title: 'Error code',
    description: 'A number that indicates the error type that occurred.',
    format: 'i32',
})), t.propOpt('data', t.any.options({
    title: 'Error data',
    description: 'A Primitive or Structured value that contains additional information about the error.',
})))));
exports.system.alias('JsonRpc2Error', exports.JsonRpc2Error);
