"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BinaryRpcMessageCodec = void 0;
const decode_1 = require("./decode");
class BinaryRpcMessageCodec {
    constructor() {
        this.id = 'rx.binary';
        this.format = 1;
    }
    encodeMessage(jsonCodec, message) {
        message.encodeBinary(jsonCodec);
    }
    encodeBatch(jsonCodec, batch) {
        const length = batch.length;
        for (let i = 0; i < length; i++)
            batch[i].encodeBinary(jsonCodec);
    }
    decodeBatch(jsonCodec, uint8) {
        const decoder = jsonCodec.decoder;
        const reader = decoder.reader;
        reader.reset(uint8);
        const size = uint8.length;
        const messages = [];
        while (reader.x < size) {
            const message = (0, decode_1.decode)(reader);
            messages.push(message);
        }
        const length = messages.length;
        for (let i = 0; i < length; i++) {
            const message = messages[i];
            const value = message.value;
            if (value) {
                const cut = value.data;
                const arr = cut.uint8.subarray(cut.start, cut.start + cut.size);
                const data = arr.length ? decoder.read(arr) : undefined;
                if (data === undefined)
                    message.value = undefined;
                else
                    value.data = data;
            }
        }
        return messages;
    }
    encode(jsonCodec, batch) {
        const encoder = jsonCodec.encoder;
        const writer = encoder.writer;
        writer.reset();
        this.encodeBatch(jsonCodec, batch);
        return writer.flush();
    }
}
exports.BinaryRpcMessageCodec = BinaryRpcMessageCodec;
