"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isSimpleType = exports.normalizeKey = exports.keywords = exports.TAB = void 0;
exports.TAB = '  ';
exports.keywords = new Set([
    'break',
    'case',
    'catch',
    'class',
    'const',
    'continue',
    'debugger',
    'default',
    'delete',
    'do',
    'else',
    'enum',
    'export',
    'extends',
    'false',
    'finally',
    'for',
    'function',
    'if',
    'import',
    'in',
    'instanceof',
    'new',
    'null',
    'return',
    'super',
    'switch',
    'this',
    'throw',
    'true',
    'try',
    'typeof',
    'var',
    'void',
    'while',
    'with',
    'as',
    'implements',
    'interface',
    'let',
    'package',
    'private',
    'protected',
    'public',
    'static',
    'yield',
    'any',
    'boolean',
    'constructor',
    'declare',
    'get',
    'module',
    'require',
    'number',
    'set',
    'string',
    'symbol',
    'type',
    'from',
    'of',
    'unknown',
]);
const normalizeKey = (prop) => /^[a-z_][a-z_0-9]*$/i.test(prop) && !exports.keywords.has(prop) ? prop : JSON.stringify(prop);
exports.normalizeKey = normalizeKey;
const isSimpleType = ({ node }) => node === 'NumberKeyword' || node === 'StringKeyword' || node === 'BooleanKeyword';
exports.isSimpleType = isSimpleType;
