"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CapacityEstimatorCodegenContext = void 0;
const codegen_1 = require("../../../util/codegen");
const json_size_1 = require("../../../json-size");
const Value_1 = require("../../../reactive-rpc/common/messages/Value");
class IncrementSizeStep {
    constructor(inc) {
        this.inc = inc;
    }
}
class CapacityEstimatorCodegenContext {
    constructor(options) {
        this.options = options;
        this.codegen = new codegen_1.Codegen({
            name: 'approxSize' + (options.name ? '_' + options.name : ''),
            args: ['r0'],
            prologue: `var size = 0;`,
            epilogue: `return size;`,
            linkable: {
                Value: Value_1.Value,
            },
            processSteps: (steps) => {
                const stepsJoined = [];
                for (let i = 0; i < steps.length; i++) {
                    const step = steps[i];
                    if (step instanceof codegen_1.CodegenStepExecJs)
                        stepsJoined.push(step);
                    else if (step instanceof IncrementSizeStep) {
                        stepsJoined.push(new codegen_1.CodegenStepExecJs(`size += ${step.inc};`));
                    }
                }
                return stepsJoined;
            },
        });
        this.codegen.linkDependency(json_size_1.maxEncodingCapacity, 'maxEncodingCapacity');
    }
    inc(inc) {
        this.codegen.step(new IncrementSizeStep(inc));
    }
    compile() {
        return this.codegen.compile();
    }
}
exports.CapacityEstimatorCodegenContext = CapacityEstimatorCodegenContext;
