"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CliParamUnd = void 0;
const tslib_1 = require("tslib");
const json_patch_1 = require("../../json-patch");
const json_pointer_1 = require("../../json-pointer");
class CliParamUnd {
    constructor() {
        this.param = 'und';
        this.title = 'Set undefined value';
        this.createInstance = (cli, pointer, rawValue) => new (class {
            constructor() {
                this.onRequest = () => tslib_1.__awaiter(this, void 0, void 0, function* () {
                    const path = (0, json_pointer_1.toPath)(pointer);
                    cli.request = (0, json_patch_1.applyPatch)(cli.request, [{ op: 'add', path, value: undefined }], { mutate: true }).doc;
                });
            }
        })();
    }
}
exports.CliParamUnd = CliParamUnd;
