"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CliParamStr = void 0;
const tslib_1 = require("tslib");
const json_patch_1 = require("../../json-patch");
const json_pointer_1 = require("../../json-pointer");
class CliParamStr {
    constructor() {
        this.param = 'str';
        this.short = 's';
        this.title = 'Set string value';
        this.example = '--s/foo=abc';
        this.createInstance = (cli, pointer, rawValue) => new (class {
            constructor() {
                this.onRequest = () => tslib_1.__awaiter(this, void 0, void 0, function* () {
                    const value = String(rawValue);
                    const path = (0, json_pointer_1.toPath)(pointer);
                    cli.request = (0, json_patch_1.applyPatch)(cli.request, [{ op: 'add', path, value }], { mutate: true }).doc;
                });
            }
        })();
    }
}
exports.CliParamStr = CliParamStr;
