"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CliParamStdin = void 0;
const tslib_1 = require("tslib");
const json_patch_1 = require("../../json-patch");
const json_pointer_1 = require("../../json-pointer");
class CliParamStdin {
    constructor() {
        this.param = 'stdin';
        this.short = 'in';
        this.title = 'Read data from STDIN';
        this.example = '--in or --in/to=/from';
        this.createInstance = (cli, pointer, rawValue) => {
            if (rawValue === true)
                rawValue = '';
            return new (class {
                constructor() {
                    this.onStdin = () => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const fromPointer = String(rawValue);
                        (0, json_pointer_1.validateJsonPointer)(fromPointer);
                        (0, json_pointer_1.validateJsonPointer)(pointer);
                        const from = (0, json_pointer_1.toPath)(fromPointer);
                        const path = (0, json_pointer_1.toPath)(pointer);
                        const value = (0, json_pointer_1.find)(cli.stdinInput, from).val;
                        cli.request = (0, json_patch_1.applyPatch)(cli.request, [{ op: 'add', path, value }], { mutate: true }).doc;
                    });
                }
            })();
        };
    }
}
exports.CliParamStdin = CliParamStdin;
