"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CliParamFormat = void 0;
const tslib_1 = require("tslib");
class CliParamFormat {
    constructor() {
        this.param = 'format';
        this.short = 'fmt';
        this.title = 'Codec to use for req/res';
        this.example = '--fmt=json:cbor';
        this.help = 'Codec format to use for encoding/decoding request/response values. To specify both request and response codecs use "<codec>", or "<reqCodec>:<resCodec>" to specify them separately.';
        this.examples = ['--format=cbor', '--format=cbor:json', '--fmt=json:msgpack', '--fmt=json:tree'];
        this.createInstance = (cli, pointer, value) => new (class {
            constructor() {
                this.onParam = () => tslib_1.__awaiter(this, void 0, void 0, function* () {
                    const format = String(value);
                    const codecs = cli.codecs.getCodecs(format);
                    const [requestCodec, responseCodec] = codecs;
                    cli.requestCodec = requestCodec;
                    cli.responseCodec = responseCodec;
                });
            }
        })();
    }
}
exports.CliParamFormat = CliParamFormat;
