"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CliParamCmd = void 0;
const tslib_1 = require("tslib");
const json_patch_1 = require("../../json-patch");
const child_process_1 = require("child_process");
const json_pointer_1 = require("../../json-pointer");
const bufferToUint8Array_1 = require("../../util/buffers/bufferToUint8Array");
const concat_1 = require("../../util/buffers/concat");
class CliParamCmd {
    constructor() {
        this.param = 'cmd';
        this.short = 'c';
        this.title = 'Set value by command';
        this.example = "--c/foo='(echo [1,2,3]):json:/1'";
        this.createInstance = (cli, pointer, rawValue) => new (class {
            constructor() {
                this.onRequest = () => tslib_1.__awaiter(this, void 0, void 0, function* () {
                    let cmd = String(rawValue);
                    let codec = cli.requestCodec;
                    let cmdPointer = '';
                    if (cmd[0] === '(') {
                        const regex = /^\((.+)\)\:([a-z0-9]*)(\:([^\:]*))$/;
                        const match = regex.exec(cmd);
                        if (match) {
                            const [, cmd_, cmdCodec, , cmdPointer_] = match;
                            cmd = cmd_;
                            if (cmdCodec)
                                codec = cli.codecs.get(cmdCodec);
                            if (cmdPointer_) {
                                (0, json_pointer_1.validateJsonPointer)(cmdPointer_);
                                cmdPointer = cmdPointer_;
                            }
                        }
                    }
                    const uint8 = yield new Promise((resolve, reject) => {
                        const ls = (0, child_process_1.spawn)(cmd, { shell: true });
                        const uint8s = [];
                        ls.stdout.on('data', (data) => {
                            uint8s.push((0, bufferToUint8Array_1.bufferToUint8Array)(data));
                        });
                        ls.stderr.on('data', (data) => {
                            reject((0, bufferToUint8Array_1.bufferToUint8Array)(data));
                        });
                        ls.on('close', (code) => {
                            resolve((0, concat_1.listToUint8)(uint8s));
                        });
                    });
                    let value = codec.decode(uint8);
                    if (cmdPointer)
                        value = (0, json_pointer_1.find)(value, (0, json_pointer_1.toPath)(cmdPointer)).val;
                    const path = (0, json_pointer_1.toPath)(pointer);
                    cli.request = (0, json_patch_1.applyPatch)(cli.request, [{ op: 'add', path, value }], { mutate: true }).doc;
                });
            }
        })();
    }
}
exports.CliParamCmd = CliParamCmd;
