"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultCodecs = void 0;
const Writer_1 = require("../util/buffers/Writer");
const CliCodecs_1 = require("./CliCodecs");
const cbor_1 = require("./codecs/cbor");
const json_1 = require("./codecs/json");
const json2_1 = require("./codecs/json2");
const json4_1 = require("./codecs/json4");
const msgpack_1 = require("./codecs/msgpack");
const raw_1 = require("./codecs/raw");
const text_1 = require("./codecs/text");
const tree_1 = require("./codecs/tree");
const ubjson_1 = require("./codecs/ubjson");
exports.defaultCodecs = new CliCodecs_1.CliCodecs();
const writer = new Writer_1.Writer(16 * 1024);
exports.defaultCodecs.register(new json_1.CliCodecJson(writer));
exports.defaultCodecs.register(new json2_1.CliCodecJson2(writer));
exports.defaultCodecs.register(new json4_1.CliCodecJson4(writer));
exports.defaultCodecs.register(new cbor_1.CliCodecCbor(writer));
exports.defaultCodecs.register(new msgpack_1.CliCodecMsgpack(writer));
exports.defaultCodecs.register(new ubjson_1.CliCodecUbjson(writer));
exports.defaultCodecs.register(new text_1.CliCodecText());
exports.defaultCodecs.register(new tree_1.CliCodecTree());
exports.defaultCodecs.register(new raw_1.CliCodecRaw());
