import { JsonDecoder } from '../../json-pack/json/JsonDecoder';
import { JsonEncoder } from '../../json-pack/json/JsonEncoder';
import type { Writer } from '../../util/buffers/Writer';
import type { CliCodec } from '../types';
export declare class CliCodecJson implements CliCodec<'json'> {
    protected readonly writer: Writer;
    readonly id = "json";
    readonly description = "JSON codec, which also supports binary data";
    protected readonly encoder: JsonEncoder;
    protected readonly decoder: JsonDecoder;
    constructor(writer: Writer);
    encode(value: unknown): Uint8Array;
    decode(bytes: Uint8Array): unknown;
}
