"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CliCodecCbor = void 0;
const CborDecoder_1 = require("../../json-pack/cbor/CborDecoder");
const CborEncoder_1 = require("../../json-pack/cbor/CborEncoder");
class CliCodecCbor {
    constructor(writer) {
        this.writer = writer;
        this.id = 'cbor';
        this.description = 'CBOR codec';
        this.encoder = new CborEncoder_1.CborEncoder(writer);
        this.decoder = new CborDecoder_1.CborDecoder();
    }
    encode(value) {
        return this.encoder.encode(value);
    }
    decode(bytes) {
        return this.decoder.read(bytes);
    }
}
exports.CliCodecCbor = CliCodecCbor;
