"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CliCodecs = void 0;
const CODEC_REGEX = /(\w{0,32})(?:\:(\w{0,32}))?/;
class CliCodecs {
    constructor() {
        this.defaultCodec = 'json4';
        this.codecs = new Map();
    }
    register(codec) {
        this.codecs.set(codec.id, codec);
    }
    get(id) {
        let codec = this.codecs.get(id);
        if (!id)
            codec = this.codecs.get(this.defaultCodec);
        if (!codec)
            throw new Error(`Codec not found: ${id}`);
        return codec;
    }
    getCodecs(format) {
        var _a;
        if (typeof format !== 'string')
            throw new Error(`Invalid --format type.`);
        if (!format) {
            const codec = this.get('');
            return [codec, codec];
        }
        const match = CODEC_REGEX.exec(format);
        if (!match)
            throw new Error(`Invalid format: ${format}`);
        const request = match[1];
        const response = (_a = match[2]) !== null && _a !== void 0 ? _a : request;
        return [this.get(request), this.get(response)];
    }
}
exports.CliCodecs = CliCodecs;
