"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isObjectReference = exports.isArrayEnd = exports.isArrayReference = exports.find = void 0;
const hasOwnProperty_1 = require("../util/hasOwnProperty");
const { isArray } = Array;
const find = (val, path) => {
    const pathLength = path.length;
    if (!pathLength)
        return { val };
    let obj;
    let key;
    for (let i = 0; i < pathLength; i++) {
        obj = val;
        key = path[i];
        if (isArray(obj)) {
            const length = obj.length;
            if (key === '-')
                key = length;
            else {
                if (typeof key === 'string') {
                    const key2 = ~~key;
                    if ('' + key2 !== key)
                        throw new Error('INVALID_INDEX');
                    key = key2;
                    if (key < 0)
                        throw new Error('INVALID_INDEX');
                }
            }
            val = obj[key];
        }
        else if (typeof obj === 'object' && !!obj) {
            val = (0, hasOwnProperty_1.hasOwnProperty)(obj, key) ? obj[key] : undefined;
        }
        else
            throw new Error('NOT_FOUND');
    }
    const ref = { val, obj, key };
    return ref;
};
exports.find = find;
const isArrayReference = (ref) => isArray(ref.obj) && typeof ref.key === 'number';
exports.isArrayReference = isArrayReference;
const isArrayEnd = (ref) => ref.obj.length === ref.key;
exports.isArrayEnd = isArrayEnd;
const isObjectReference = (ref) => typeof ref.obj === 'object' && typeof ref.key === 'string';
exports.isObjectReference = isObjectReference;
