import type { Path } from './types';
export interface Reference {
    readonly val: unknown;
    readonly obj?: unknown | object | unknown[];
    readonly key?: string | number;
}
export declare const find: (val: unknown, path: Path) => Reference;
export interface ArrayReference<T = unknown> {
    readonly val: undefined | T;
    readonly obj: T[];
    readonly key: number;
}
export declare const isArrayReference: <T = unknown>(ref: Reference) => ref is ArrayReference<T>;
export declare const isArrayEnd: (ref: ArrayReference) => boolean;
export interface ObjectReference<T = unknown> {
    readonly val: T;
    readonly obj: Record<string, T>;
    readonly key: string;
}
export declare const isObjectReference: <T = unknown>(ref: Reference) => ref is ObjectReference<T>;
