"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createMatcherDefault = exports.isElementNode = exports.isTextNode = void 0;
const { isArray } = Array;
const isTextNode = (node) => !!node && typeof node === 'object' && typeof node.text === 'string';
exports.isTextNode = isTextNode;
const isElementNode = (node) => !!node && typeof node === 'object' && isArray(node.children);
exports.isElementNode = isElementNode;
const createMatcherDefault = (pattern, ignoreCase) => {
    const reg = new RegExp(pattern, ignoreCase ? 'i' : undefined);
    return (value) => reg.test(value);
};
exports.createMatcherDefault = createMatcherDefault;
