import type { CompactTestTypeOp } from '../codec/compact/types';
import { AbstractPredicateOp } from './AbstractPredicateOp';
import { OperationTestType, JsonPatchTypes } from '../types';
import { Path } from '../../json-pointer';
import { OPCODE } from '../constants';
import { AbstractOp } from './AbstractOp';
import type { IMessagePackEncoder } from '../../json-pack/msgpack';
export declare class OpTestType extends AbstractPredicateOp<'test_type'> {
    readonly type: JsonPatchTypes[];
    constructor(path: Path, type: JsonPatchTypes[]);
    op(): "test_type";
    code(): OPCODE;
    test(doc: unknown): boolean;
    toJson(parent?: AbstractOp): OperationTestType;
    toCompact(parent: undefined | AbstractOp, verbose: boolean): CompactTestTypeOp;
    encode(encoder: IMessagePackEncoder, parent?: AbstractOp): void;
}
