import type { CompactStrInsOp } from '../codec/compact/types';
import { AbstractOp } from './AbstractOp';
import { OperationStrIns } from '../types';
import { Path } from '../../json-pointer';
import { OPCODE } from '../constants';
import type { IMessagePackEncoder } from '../../json-pack/msgpack';
export declare class OpStrIns extends AbstractOp<'str_ins'> {
    readonly pos: number;
    readonly str: string;
    constructor(path: Path, pos: number, str: string);
    op(): "str_ins";
    code(): OPCODE;
    apply(doc: unknown): {
        doc: unknown;
        old: string | undefined;
    };
    toJson(parent?: AbstractOp): OperationStrIns;
    toCompact(parent: undefined | AbstractOp, verbose: boolean): CompactStrInsOp;
    encode(encoder: IMessagePackEncoder, parent?: AbstractOp): void;
}
