import type { CompactReplaceOp } from '../codec/compact/types';
import { AbstractOp } from './AbstractOp';
import { OperationReplace } from '../types';
import { Path } from '../../json-pointer';
import { OPCODE } from '../constants';
import type { IMessagePackEncoder } from '../../json-pack/msgpack';
export declare class OpReplace extends AbstractOp<'replace'> {
    readonly value: unknown;
    readonly oldValue: unknown;
    constructor(path: Path, value: unknown, oldValue: unknown);
    op(): "replace";
    code(): OPCODE;
    apply(doc: unknown): {
        doc: unknown;
        old: {} | null;
    };
    toJson(parent?: AbstractOp): OperationReplace;
    toCompact(parent: undefined | AbstractOp, verbose: boolean): CompactReplaceOp;
    encode(encoder: IMessagePackEncoder, parent?: AbstractOp): void;
}
