import type { CompactRemoveOp } from '../codec/compact/types';
import { AbstractOp } from './AbstractOp';
import { OperationRemove } from '../types';
import { Path } from '../../json-pointer';
import { OPCODE } from '../constants';
import type { IMessagePackEncoder } from '../../json-pack/msgpack';
export declare class OpRemove extends AbstractOp<'remove'> {
    readonly oldValue: unknown;
    constructor(path: Path, oldValue: unknown);
    op(): "remove";
    code(): OPCODE;
    apply(doc: unknown): {
        doc: unknown;
        old: {} | null;
    };
    toJson(parent?: AbstractOp): OperationRemove;
    toCompact(parent: undefined | AbstractOp, verbose: boolean): CompactRemoveOp;
    encode(encoder: IMessagePackEncoder, parent?: AbstractOp): void;
}
