"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpMatches = void 0;
const AbstractPredicateOp_1 = require("./AbstractPredicateOp");
const json_pointer_1 = require("../../json-pointer");
class OpMatches extends AbstractPredicateOp_1.AbstractPredicateOp {
    constructor(path, value, ignore_case, createMatcher) {
        super(path);
        this.value = value;
        this.ignore_case = ignore_case;
        this.matcher = createMatcher(value, ignore_case);
    }
    op() {
        return 'matches';
    }
    code() {
        return 35;
    }
    test(doc) {
        const { val } = (0, json_pointer_1.find)(doc, this.path);
        if (typeof val !== 'string')
            return false;
        const test = this.matcher(val);
        return test;
    }
    toJson(parent) {
        const op = {
            op: 'matches',
            path: (0, json_pointer_1.formatJsonPointer)(parent ? this.path.slice(parent.path.length) : this.path),
            value: this.value,
        };
        if (this.ignore_case)
            op.ignore_case = this.ignore_case;
        return op;
    }
    toCompact(parent, verbose) {
        const opcode = verbose ? 'matches' : 35;
        return this.ignore_case
            ? [opcode, parent ? this.path.slice(parent.path.length) : this.path, this.value, 1]
            : [opcode, parent ? this.path.slice(parent.path.length) : this.path, this.value];
    }
    encode(encoder, parent) {
        const ignoreCase = this.ignore_case;
        encoder.encodeArrayHeader(ignoreCase ? 4 : 3);
        encoder.writer.u8(35);
        encoder.encodeArray(parent ? this.path.slice(parent.path.length) : this.path);
        encoder.encodeString(this.value);
        if (ignoreCase)
            encoder.writer.u8(1);
    }
}
exports.OpMatches = OpMatches;
