import type { CompactMatchesOp } from '../codec/compact/types';
import type { OperationMatches, CreateRegexMatcher, RegexMatcher } from '../types';
import { AbstractPredicateOp } from './AbstractPredicateOp';
import { Path } from '../../json-pointer';
import { OPCODE } from '../constants';
import { AbstractOp } from './AbstractOp';
import type { IMessagePackEncoder } from '../../json-pack/msgpack';
export declare class OpMatches extends AbstractPredicateOp<'matches'> {
    readonly value: string;
    readonly ignore_case: boolean;
    readonly matcher: RegexMatcher;
    constructor(path: Path, value: string, ignore_case: boolean, createMatcher: CreateRegexMatcher);
    op(): "matches";
    code(): OPCODE;
    test(doc: unknown): boolean;
    toJson(parent?: AbstractOp): OperationMatches;
    toCompact(parent: undefined | AbstractOp, verbose: boolean): CompactMatchesOp;
    encode(encoder: IMessagePackEncoder, parent?: AbstractOp): void;
}
