import type { CompactLessOp } from '../codec/compact/types';
import { AbstractPredicateOp } from './AbstractPredicateOp';
import { OperationLess } from '../types';
import { Path } from '../../json-pointer';
import { OPCODE } from '../constants';
import { AbstractOp } from './AbstractOp';
import type { IMessagePackEncoder } from '../../json-pack/msgpack';
export declare class OpLess extends AbstractPredicateOp<'less'> {
    readonly value: number;
    constructor(path: Path, value: number);
    op(): "less";
    code(): OPCODE;
    test(doc: unknown): boolean;
    toJson(parent?: AbstractOp): OperationLess;
    toCompact(parent: undefined | AbstractOp, verbose: boolean): CompactLessOp;
    encode(encoder: IMessagePackEncoder, parent?: AbstractOp): void;
}
