"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpInc = void 0;
const AbstractOp_1 = require("./AbstractOp");
const json_pointer_1 = require("../../json-pointer");
class OpInc extends AbstractOp_1.AbstractOp {
    constructor(path, inc) {
        super(path);
        this.inc = inc;
    }
    op() {
        return 'inc';
    }
    code() {
        return 9;
    }
    apply(doc) {
        const ref = (0, json_pointer_1.find)(doc, this.path);
        const result = this.inc + Number(ref.val);
        if (ref.obj)
            ref.obj[ref.key] = result;
        else
            doc = result;
        return { doc, old: ref.val };
    }
    toJson(parent) {
        const op = {
            op: 'inc',
            path: (0, json_pointer_1.formatJsonPointer)(this.path),
            inc: this.inc,
        };
        return op;
    }
    toCompact(parent, verbose) {
        const opcode = verbose ? 'inc' : 9;
        return [opcode, this.path, this.inc];
    }
    encode(encoder, parent) {
        encoder.encodeArrayHeader(3);
        encoder.writer.u8(9);
        encoder.encodeArray(this.path);
        encoder.encodeNumber(this.inc);
    }
}
exports.OpInc = OpInc;
