import type { CompactFlipOp } from '../codec/compact/types';
import { AbstractOp } from './AbstractOp';
import { OperationFlip } from '../types';
import { Path } from '../../json-pointer';
import { OPCODE } from '../constants';
import type { IMessagePackEncoder } from '../../json-pack/msgpack';
export declare class OpFlip extends AbstractOp<'flip'> {
    constructor(path: Path);
    op(): "flip";
    code(): OPCODE;
    apply(doc: unknown): {
        doc: unknown;
        old: unknown;
    };
    toJson(parent?: AbstractOp): OperationFlip;
    toCompact(parent: undefined | AbstractOp, verbose: boolean): CompactFlipOp;
    encode(encoder: IMessagePackEncoder, parent?: AbstractOp): void;
}
