import type { CompactExtendOp } from '../codec/compact/types';
import { AbstractOp } from './AbstractOp';
import { OperationExtend } from '../types';
import { Path } from '../../json-pointer';
import { OPCODE } from '../constants';
import type { IMessagePackEncoder } from '../../json-pack/msgpack';
export declare class OpExtend extends AbstractOp<'extend'> {
    readonly props: Record<string, unknown>;
    readonly deleteNull: boolean;
    constructor(path: Path, props: Record<string, unknown>, deleteNull: boolean);
    op(): "extend";
    code(): OPCODE;
    apply(doc: unknown): {
        doc: unknown;
    };
    private extend;
    toJson(parent?: AbstractOp): OperationExtend;
    toCompact(parent: undefined | AbstractOp, verbose: boolean): CompactExtendOp;
    encode(encoder: IMessagePackEncoder, parent?: AbstractOp): void;
}
