"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.operatorsMap = exports.operators = void 0;
const util_1 = require("../util");
const arithmetic_1 = require("./arithmetic");
const comparison_1 = require("./comparison");
const logical_1 = require("./logical");
const type_1 = require("./type");
const container_1 = require("./container");
const string_1 = require("./string");
const binary_1 = require("./binary");
const array_1 = require("./array");
const object_1 = require("./object");
const branching_1 = require("./branching");
const input_1 = require("./input");
const bitwise_1 = require("./bitwise");
exports.operators = [
    ...arithmetic_1.arithmeticOperators,
    ...comparison_1.comparisonOperators,
    ...logical_1.logicalOperators,
    ...type_1.typeOperators,
    ...container_1.containerOperators,
    ...string_1.stringOperators,
    ...binary_1.binaryOperators,
    ...array_1.arrayOperators,
    ...object_1.objectOperators,
    ...branching_1.branchingOperators,
    ...input_1.inputOperators,
    ...bitwise_1.bitwiseOperators,
];
exports.operatorsMap = (0, util_1.operatorsToMap)(exports.operators);
