"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bitwiseOperators = void 0;
const tslib_1 = require("tslib");
const util = tslib_1.__importStar(require("../util"));
const codegen_steps_1 = require("../codegen-steps");
const toInt = util.int;
exports.bitwiseOperators = [
    [
        '&',
        ['bitAnd'],
        -1,
        (expr, ctx) => {
            return expr.slice(2).reduce((acc, e) => acc & toInt(ctx.eval(e, ctx)), toInt(ctx.eval(expr[1], ctx)));
        },
        (ctx) => {
            const js = ctx.operands.map((expr) => `(~~(${expr}))`).join('&');
            return new codegen_steps_1.Expression(js);
        },
    ],
    [
        '|',
        ['bitOr'],
        -1,
        (expr, ctx) => {
            return expr.slice(2).reduce((acc, e) => acc | toInt(ctx.eval(e, ctx)), toInt(ctx.eval(expr[1], ctx)));
        },
        (ctx) => {
            const js = ctx.operands.map((expr) => `(~~(${expr}))`).join('|');
            return new codegen_steps_1.Expression(js);
        },
    ],
    [
        '^',
        ['bitXor'],
        -1,
        (expr, ctx) => {
            return expr.slice(2).reduce((acc, e) => acc ^ toInt(ctx.eval(e, ctx)), toInt(ctx.eval(expr[1], ctx)));
        },
        (ctx) => {
            const js = ctx.operands.map((expr) => `(~~(${expr}))`).join('^');
            return new codegen_steps_1.Expression(js);
        },
    ],
    [
        '~',
        ['bitNot'],
        1,
        (expr, ctx) => {
            return ~toInt(ctx.eval(expr[1], ctx));
        },
        (ctx) => {
            const js = `~(${ctx.operands[0]})`;
            return new codegen_steps_1.Expression(js);
        },
    ],
];
