import { Codegen } from '../util/codegen/Codegen';
import { ExpressionResult } from './codegen-steps';
import { createEvaluate } from './createEvaluate';
import type * as types from './types';
export type JsonExpressionFn = (ctx: types.JsonExpressionExecutionContext) => unknown;
export interface JsonExpressionCodegenOptions extends types.JsonExpressionCodegenContext {
    expression: types.Expr;
    operators: types.OperatorMap;
}
export declare class JsonExpressionCodegen {
    protected options: JsonExpressionCodegenOptions;
    protected codegen: Codegen<JsonExpressionFn>;
    protected evaluate: ReturnType<typeof createEvaluate>;
    constructor(options: JsonExpressionCodegenOptions);
    private linkedOperandDeps;
    private linkOperandDeps;
    private operatorConst;
    private subExpression;
    protected onExpression(expr: types.Expr | unknown): ExpressionResult;
    run(): this;
    generate(): import("../util/codegen").JavaScriptLinked<JsonExpressionFn, unknown[]>;
    compile(): (ctx: types.JsonExpressionExecutionContext) => unknown;
}
