"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Extensions = void 0;
const printTree_1 = require("../../util/print/printTree");
class Extensions {
    constructor() {
        this.ext = {};
    }
    register(extension) {
        this.ext[extension.id] = extension;
    }
    get(id) {
        return this.ext[id];
    }
    size() {
        return Object.keys(this.ext).length;
    }
    toString(tab = '') {
        const keys = Object.keys(this.ext)
            .map((k) => +k)
            .sort();
        return (this.constructor.name +
            (0, printTree_1.printTree)(tab, keys.map((k) => (tab) => `${k}: ${this.ext[k].Node.name}`)));
    }
}
exports.Extensions = Extensions;
