export interface JsonCrdtVerboseDocument {
    time: JsonCrdtVerboseServerTimestamp | JsonCrdtVerboseLogicalTimestamp[];
    root: JsonCrdtVerboseVal;
}
export type JsonCrdtVerboseTimestamp = JsonCrdtVerboseServerTimestamp | JsonCrdtVerboseLogicalTimestamp;
export type JsonCrdtVerboseLogicalTimestamp = [sessionId: number, time: number];
export type JsonCrdtVerboseServerTimestamp = number;
export interface JsonCrdtVerboseCon {
    type: 'con';
    id: JsonCrdtVerboseTimestamp;
    timestamp?: boolean;
    value?: unknown | JsonCrdtVerboseTimestamp;
}
export interface JsonCrdtVerboseVal {
    type: 'val';
    id: JsonCrdtVerboseTimestamp;
    value: JsonCrdtNode;
}
export interface JsonCrdtVerboseObj {
    type: 'obj';
    id: JsonCrdtVerboseTimestamp;
    map: Record<string, JsonCrdtNode>;
}
export interface JsonCrdtVerboseVec {
    type: 'vec';
    id: JsonCrdtVerboseTimestamp;
    map: (null | JsonCrdtNode)[];
}
export interface JsonCrdtVerboseStr {
    type: 'str';
    id: JsonCrdtVerboseTimestamp;
    chunks: (JsonCrdtVerboseStrChunk | JsonCrdtVerboseTombstone)[];
}
export interface JsonCrdtVerboseStrChunk {
    id: JsonCrdtVerboseTimestamp;
    value: string;
}
export interface JsonCrdtVerboseBin {
    type: 'bin';
    id: JsonCrdtVerboseTimestamp;
    chunks: (JsonCrdtVerboseBinChunk | JsonCrdtVerboseTombstone)[];
}
export interface JsonCrdtVerboseBinChunk {
    id: JsonCrdtVerboseTimestamp;
    value: string;
}
export interface JsonCrdtVerboseArr {
    type: 'arr';
    id: JsonCrdtVerboseTimestamp;
    chunks: (JsonCrdtVerboseArrChunk | JsonCrdtVerboseTombstone)[];
}
export interface JsonCrdtVerboseArrChunk {
    id: JsonCrdtVerboseTimestamp;
    value: JsonCrdtNode[];
}
export interface JsonCrdtVerboseTombstone {
    id: JsonCrdtVerboseTimestamp;
    span: number;
}
export type JsonCrdtNode = JsonCrdtVerboseObj | JsonCrdtVerboseVec | JsonCrdtVerboseArr | JsonCrdtVerboseStr | JsonCrdtVerboseBin | JsonCrdtVerboseVal | JsonCrdtVerboseCon;
