import { ClockDecoder } from '../../../../json-crdt-patch/codec/clock/ClockDecoder';
import { CrdtReader } from '../../../../json-crdt-patch/util/binary/CrdtReader';
import { ITimestampStruct } from '../../../../json-crdt-patch/clock';
import { Model } from '../../../model/Model';
import { CborDecoderBase } from '../../../../json-pack/cbor/CborDecoderBase';
import { ArrNode, BinNode, ConNode, ObjNode, StrNode, ValNode, VecNode, type JsonNode } from '../../../nodes';
export declare class Decoder extends CborDecoderBase<CrdtReader> {
    protected doc: Model;
    protected clockDecoder?: ClockDecoder;
    protected time: number;
    constructor();
    decode(data: Uint8Array): Model;
    protected decodeClockTable(): void;
    protected ts(): ITimestampStruct;
    protected cRoot(): JsonNode;
    protected cNode(): JsonNode;
    protected cCon(id: ITimestampStruct, length: number): ConNode;
    protected cVal(id: ITimestampStruct): ValNode;
    protected cObj(id: ITimestampStruct, length: number): ObjNode;
    protected cObjChunk(obj: ObjNode): void;
    protected cVec(id: ITimestampStruct, length: number): VecNode;
    protected cStr(id: ITimestampStruct, length: number): StrNode;
    private cStrChunk;
    protected cBin(id: ITimestampStruct, length: number): BinNode;
    private cBinChunk;
    protected cArr(id: ITimestampStruct, length: number): ArrNode;
    private readonly cArrChunk;
}
