import { ITimestampStruct } from '../../../../json-crdt-patch/clock';
import { ClockTable } from '../../../../json-crdt-patch/codec/clock/ClockTable';
import { CrdtWriter } from '../../../../json-crdt-patch/util/binary/CrdtWriter';
import { CborEncoder } from '../../../../json-pack/cbor/CborEncoder';
import { Model } from '../../../model';
import * as nodes from '../../../nodes';
import { CRDT_MAJOR_OVERLAY } from '../../structural/binary/constants';
import { IndexedFields } from './types';
export declare class Encoder {
    readonly enc: CborEncoder<CrdtWriter>;
    protected clockTable?: ClockTable;
    constructor(writer?: CrdtWriter);
    encode(doc: Model, clockTable?: ClockTable): IndexedFields;
    protected readonly onNode: (result: IndexedFields, node: nodes.JsonNode) => void;
    encodeNode(node: nodes.JsonNode): Uint8Array;
    protected ts(id: ITimestampStruct): void;
    protected writeTL(majorOverlay: CRDT_MAJOR_OVERLAY, length: number): void;
    encodeCon(node: nodes.ConNode): Uint8Array;
    encodeVal(node: nodes.ValNode): Uint8Array;
    encodeObj(node: nodes.ObjNode): Uint8Array;
    private readonly onObjKey;
    encodeVec(node: nodes.VecNode): Uint8Array;
    encodeStr(node: nodes.StrNode): Uint8Array;
    encodeBin(node: nodes.BinNode): Uint8Array;
    encodeArr(node: nodes.ArrNode): Uint8Array;
}
