"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defineUtilRoutes = void 0;
const tslib_1 = require("tslib");
const defineUtilRoutes = (router) => {
    const router2 = router.extend(({ t }) => ({
        'util.time': t
            .Function(t.undef, t.num)
            .options({
            title: 'Get time',
            description: 'Returns the current time',
        })
            .implement(() => tslib_1.__awaiter(void 0, void 0, void 0, function* () { return Date.now(); })),
        'util.throw': t
            .Function(t.undef, t.undef)
            .options({
            title: 'Throw an error',
            description: 'This method always throws an error.',
        })
            .implement((req, ctx) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
            throw new Error(`${ctx.cli.argv[0]} always throws an error.`);
        })),
        'util.schema': t
            .Function(t.Object(t.prop('alias', t.str)), t.Object(t.prop('schema', t.any)))
            .options({
            title: 'Get schema',
            description: 'Returns the schema definition of a type',
        })
            .implement(({ alias }, ctx) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
            const resolved = ctx.cli.types.resolve(alias);
            return {
                schema: resolved.getType().getSchema(),
            };
        })),
    }));
    return router2;
};
exports.defineUtilRoutes = defineUtilRoutes;
