"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const json_type_cli_1 = require("../json-type-cli");
const TypeRouter_1 = require("../json-type/system/TypeRouter");
const crdt_1 = require("./routes/crdt");
const patch_1 = require("./routes/patch");
const util_1 = require("./routes/util");
const router = ((0, patch_1.definePatchRoutes)((0, crdt_1.defineCrdtRoutes)((0, util_1.defineUtilRoutes)(TypeRouter_1.TypeRouter.create()))));
const cli = (0, json_type_cli_1.createCli)({
    router,
    version: 'v' + require('../../package.json').version,
    cmd: 'jj',
});
cli.run();
