import { Printable } from '../print/types';
import { RouteMatcher } from './codegen';
import { RoutingTreeNode } from './tree';
import { Step } from './types';
export interface RouterOptions {
    defaultUntil?: string;
}
export declare class Router implements Printable {
    readonly options: RouterOptions;
    readonly destinations: Destination[];
    constructor(options?: RouterOptions);
    add(route: string | string[], data: unknown): void;
    addDestination(destination: Destination): void;
    tree(): RoutingTreeNode;
    compile(): RouteMatcher;
    toString(tab?: string): string;
}
export declare class Destination implements Printable {
    readonly routes: Route[];
    readonly data: unknown;
    static from(def: string | string[], data: unknown, defaultUntil?: string): Destination;
    readonly match: Match;
    constructor(routes: Route[], data: unknown);
    toString(tab?: string): string;
}
export declare class Route implements Printable {
    readonly steps: Step[];
    static from(str: string, defaultUntil?: string): Route;
    constructor(steps: Step[]);
    toText(): string;
    toString(tab?: string): string;
}
export declare class Match {
    readonly data: unknown;
    params: string[] | null;
    constructor(data: unknown, params: string[] | null);
}
