import type { RpcMessageStreamProcessor } from '../../common';
import type { ConnectionContext } from '../context';
export type HttpMethod = 'get' | 'post' | 'put' | 'delete' | 'patch' | 'head' | 'options' | 'trace' | 'connect';
export type HttpMethodPermissive = HttpMethod | 'GET' | 'POST' | 'PUT' | 'DELETE' | 'PATCH' | 'HEAD' | 'OPTIONS' | 'TRACE' | 'CONNECT';
export type RouteHandler<Ctx extends ConnectionContext> = (ctx: Ctx) => void;
export type JsonRouteHandler<Ctx extends ConnectionContext> = (ctx: Ctx) => void;
export interface RpcWebSocket<Ctx extends ConnectionContext = ConnectionContext> extends WebSocket {
    ctx: Ctx;
    rpc?: RpcMessageStreamProcessor<Ctx>;
}
export type RecognizedString = string | ArrayBuffer | Uint8Array | Int8Array | Uint16Array | Int16Array | Uint32Array | Int32Array | Float32Array | Float64Array;
export interface HttpRequest {
    getHeader(lowerCaseKey: RecognizedString): string;
    getUrl(): string;
    getMethod(): string;
    getQuery(): string;
    getQuery(key: string): string;
}
export interface HttpResponse {
    writeStatus(status: RecognizedString): HttpResponse;
    writeHeader(key: RecognizedString, value: RecognizedString): HttpResponse;
    write(chunk: RecognizedString): boolean;
    end(body?: RecognizedString, closeConnection?: boolean): HttpResponse;
    close(): HttpResponse;
    onAborted(handler: () => void): HttpResponse;
    onData(handler: (chunk: ArrayBuffer, isLast: boolean) => void): HttpResponse;
    getRemoteAddressAsText(): ArrayBuffer;
    cork(cb: () => void): HttpResponse;
    upgrade<T>(userData: T, secWebSocketKey: RecognizedString, secWebSocketProtocol: RecognizedString, secWebSocketExtensions: RecognizedString, context: unknown): void;
    [key: string]: any;
}
export interface TemplatedApp {
    listen(host: RecognizedString, port: number, cb: (listenSocket: unknown) => void): TemplatedApp;
    get(pattern: RecognizedString, handler: (res: HttpResponse, req: HttpRequest) => void): TemplatedApp;
    post(pattern: RecognizedString, handler: (res: HttpResponse, req: HttpRequest) => void): TemplatedApp;
    options(pattern: RecognizedString, handler: (res: HttpResponse, req: HttpRequest) => void): TemplatedApp;
    del(pattern: RecognizedString, handler: (res: HttpResponse, req: HttpRequest) => void): TemplatedApp;
    patch(pattern: RecognizedString, handler: (res: HttpResponse, req: HttpRequest) => void): TemplatedApp;
    put(pattern: RecognizedString, handler: (res: HttpResponse, req: HttpRequest) => void): TemplatedApp;
    head(pattern: RecognizedString, handler: (res: HttpResponse, req: HttpRequest) => void): TemplatedApp;
    connect(pattern: RecognizedString, handler: (res: HttpResponse, req: HttpRequest) => void): TemplatedApp;
    trace(pattern: RecognizedString, handler: (res: HttpResponse, req: HttpRequest) => void): TemplatedApp;
    any(pattern: RecognizedString, handler: (res: HttpResponse, req: HttpRequest) => void): TemplatedApp;
    ws(pattern: RecognizedString, behavior: WebSocketBehavior): TemplatedApp;
}
export interface WebSocketBehavior {
    maxPayloadLength?: number;
    idleTimeout?: number;
    compression?: number;
    maxBackpressure?: number;
    sendPingsAutomatically?: boolean;
    upgrade?: (res: HttpResponse, req: HttpRequest, context: unknown) => void;
    open?: (ws: WebSocket) => void;
    message?: (ws: WebSocket, message: ArrayBuffer, isBinary: boolean) => void;
    drain?: (ws: WebSocket) => void;
    close?: (ws: WebSocket, code: number, message: ArrayBuffer) => void;
    ping?: (ws: WebSocket, message: ArrayBuffer) => void;
    pong?: (ws: WebSocket, message: ArrayBuffer) => void;
}
export interface WebSocket {
    send(message: RecognizedString, isBinary?: boolean, compress?: boolean): number;
    getBufferedAmount(): number;
    end(code?: number, shortMessage?: RecognizedString): void;
    close(): void;
    ping(message?: RecognizedString): number;
    subscribe(topic: RecognizedString): boolean;
    unsubscribe(topic: RecognizedString): boolean;
    isSubscribed(topic: RecognizedString): boolean;
    getTopics(): string[];
    publish(topic: RecognizedString, message: RecognizedString, isBinary?: boolean, compress?: boolean): boolean;
    cork(cb: () => void): WebSocket;
    getRemoteAddress(): ArrayBuffer;
    getRemoteAddressAsText(): ArrayBuffer;
    [key: string]: any;
}
