"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.subscribeCompleteObserver = void 0;
const microtask_1 = require("./microtask");
function subscribeCompleteObserver(observable, observer) {
    let completed = false;
    let completeCalled = false;
    let tasks = 0;
    return observable.subscribe({
        next: (value) => {
            tasks++;
            (0, microtask_1.microtask)(() => {
                tasks--;
                if (completed && !tasks) {
                    completeCalled = true;
                    observer.complete(value, true);
                }
                else {
                    observer.next(value);
                }
            });
        },
        error: (error) => {
            if (!tasks)
                observer.error(error);
            else
                (0, microtask_1.microtask)(() => {
                    observer.error(error);
                });
        },
        complete: () => {
            completed = true;
            if (completeCalled)
                return;
            if (!tasks)
                observer.complete(undefined, false);
            else {
                (0, microtask_1.microtask)(() => {
                    if (completeCalled)
                        return;
                    observer.complete(undefined, false);
                });
            }
        },
    });
}
exports.subscribeCompleteObserver = subscribeCompleteObserver;
