import * as msg from '../../messages';
import { TimedQueue } from '../../util/TimedQueue';
import { Observable } from 'rxjs';
import type { RpcClient } from './types';
export interface StaticRpcClientOptions {
    send?: (messages: msg.ReactiveRpcClientMessage[]) => Promise<msg.ReactiveRpcServerMessage[]>;
    bufferSize?: number;
    bufferTime?: number;
}
export declare class StaticRpcClient implements RpcClient {
    private id;
    readonly buffer: TimedQueue<msg.ReactiveRpcClientMessage>;
    onsend: (messages: msg.ReactiveRpcClientMessage[]) => Promise<msg.ReactiveRpcServerMessage[]>;
    private readonly calls;
    constructor({ send, bufferSize, bufferTime }: StaticRpcClientOptions);
    call$(method: string, data: unknown | Observable<unknown>): Observable<unknown>;
    call(method: string, request: unknown): Promise<unknown>;
    notify(method: string, data: undefined | unknown): void;
}
