"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FetchRpcClient = void 0;
const StaticRpcClient_1 = require("./StaticRpcClient");
const EncodedStaticRpcClient_1 = require("./EncodedStaticRpcClient");
class FetchRpcClient {
    constructor(options) {
        const { msgCodec, reqCodec, resCodec = reqCodec, url } = options;
        let contentType = `application/x.rpc.${msgCodec.id}.${reqCodec.id}`;
        if (reqCodec.id !== resCodec.id)
            contentType += `-${resCodec.id}`;
        const myFetch = options.fetch || fetch;
        this.client = new EncodedStaticRpcClient_1.EncodedStaticRpcClient({
            client: new StaticRpcClient_1.StaticRpcClient({
                bufferSize: options.bufferSize,
                bufferTime: options.bufferTime,
            }),
            msgCodec,
            reqCodec,
            resCodec,
            send: async (body) => {
                const response = await myFetch(url, {
                    method: 'POST',
                    headers: {
                        'Content-Type': contentType,
                    },
                    body,
                });
                const buffer = await response.arrayBuffer();
                return new Uint8Array(buffer);
            },
        });
    }
    call$(method, data) {
        return this.client.call$(method, data);
    }
    async call(method, request) {
        return this.call(method, request);
    }
    notify(method, data) {
        this.notify(method, data);
    }
}
exports.FetchRpcClient = FetchRpcClient;
