import type { Observable, Observer } from 'rxjs';
import type { IStaticRpcMethod, IStreamingRpcMethod } from '../methods/types';
import type { Value } from '../../messages/Value';
export type RpcApiMap<Ctx = unknown> = {
    [name: string]: IStaticRpcMethod<Ctx, any, any> | IStreamingRpcMethod<Ctx, any, any>;
};
export interface Call<Req = unknown, Res = unknown> {
    req$: Observer<Req>;
    reqUnsubscribe$: Observable<null>;
    res$: Observable<Value<Res>>;
}
