import { RpcMessageFormat } from '../constants';
import * as msg from '../../messages';
import type { RpcMessageCodec } from '../types';
import type { JsonValueCodec } from '../../../../json-pack/codecs/types';
import type * as types from './types';
export declare class CompactRpcMessageCodec implements RpcMessageCodec {
    id: string;
    format: RpcMessageFormat;
    encodeMessage(jsonCodec: JsonValueCodec, message: msg.ReactiveRpcMessage): void;
    encodeBatch(jsonCodec: JsonValueCodec, batch: msg.ReactiveRpcMessage[]): void;
    encode(jsonCodec: JsonValueCodec, batch: msg.ReactiveRpcMessage[]): Uint8Array;
    decodeBatch(jsonCodec: JsonValueCodec, uint8: Uint8Array): msg.ReactiveRpcMessage[];
    fromJson(compact: types.CompactMessage): msg.ReactiveRpcMessage;
}
