"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decode = void 0;
const Uint8ArrayCut_1 = require("../../../../util/buffers/Uint8ArrayCut");
const messages_1 = require("../../messages");
const Value_1 = require("../../messages/Value");
const decode = (reader) => {
    const word = reader.u32();
    const type = word >>> 29;
    switch (type) {
        case 0: {
            const z = word & 0xff;
            const x = word >>> 8;
            const name = reader.ascii(z);
            const cut = new Uint8ArrayCut_1.Uint8ArrayCut(reader.uint8, reader.x, x);
            const value = new Value_1.Value(cut, undefined);
            reader.skip(x);
            return new messages_1.NotificationMessage(name, value);
        }
        case 1:
        case 2:
        case 3: {
            const z = reader.u8();
            const name = reader.ascii(z);
            const cutStart = reader.x;
            let x = 0, y = 0;
            if (word & 268435456) {
                if (word & 32768) {
                    x = ((4095 & (word >>> 16)) << 15) | (word & 32767);
                    reader.skip(x);
                    y = reader.u16();
                }
                else {
                    x = ((4095 & (word >>> 16)) << 7) | ((word >>> 8) & 0x7f);
                    reader.skip(x);
                    y = ((word & 0xff) << 8) | reader.u8();
                }
            }
            else {
                x = (word >>> 16) & 4095;
                y = word & 0xffff;
                reader.skip(x);
            }
            const cut = new Uint8ArrayCut_1.Uint8ArrayCut(reader.uint8, cutStart, x);
            const value = new Value_1.Value(cut, undefined);
            switch (type) {
                case 1:
                    return new messages_1.RequestDataMessage(y, name, value);
                case 2:
                    return new messages_1.RequestCompleteMessage(y, name, value);
                case 3:
                    return new messages_1.RequestErrorMessage(y, name, value);
            }
            break;
        }
        case 4:
        case 5:
        case 6: {
            const cutStart = reader.x;
            let x = 0, y = 0;
            if (word & 268435456) {
                if (word & 32768) {
                    x = ((4095 & (word >>> 16)) << 15) | (word & 32767);
                    reader.skip(x);
                    y = reader.u16();
                }
                else {
                    x = ((4095 & (word >>> 16)) << 7) | ((word >>> 8) & 0x7f);
                    reader.skip(x);
                    y = ((word & 0xff) << 8) | reader.u8();
                }
            }
            else {
                x = (word >>> 16) & 4095;
                y = word & 0xffff;
                reader.skip(x);
            }
            const cut = new Uint8ArrayCut_1.Uint8ArrayCut(reader.uint8, cutStart, x);
            const value = new Value_1.Value(cut, undefined);
            switch (type) {
                case 4:
                    return new messages_1.ResponseDataMessage(y, value);
                case 5:
                    return new messages_1.ResponseCompleteMessage(y, value);
                case 6:
                    return new messages_1.ResponseErrorMessage(y, value);
            }
            break;
        }
        case 7: {
            const isResponse = word & 65536;
            const id = word & 0xffff;
            return isResponse ? new messages_1.ResponseUnsubscribeMessage(id) : new messages_1.RequestUnsubscribeMessage(id);
        }
    }
    throw new Error('UNKNOWN_MSG');
};
exports.decode = decode;
