"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RpcCodec = void 0;
class RpcCodec {
    constructor(valueCodec, messageCodec) {
        this.valueCodec = valueCodec;
        this.messageCodec = messageCodec;
    }
    encode(messages) {
        const valueCodec = this.valueCodec;
        const encoder = valueCodec.encoder;
        const writer = encoder.writer;
        writer.reset();
        this.messageCodec.encodeBatch(valueCodec, messages);
        return writer.flush();
    }
    decode(data) {
        const valueCodec = this.valueCodec;
        const decoder = valueCodec.decoder;
        const reader = decoder.reader;
        reader.reset(data);
        return this.messageCodec.decodeBatch(valueCodec, data);
    }
}
exports.RpcCodec = RpcCodec;
